"use client"

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { ChartTooltip, ChartTooltipContent } from "@/components/visualizations/chart"
import { ChartDisplay } from "@/components/visualizations/chart.display"
import { potentialDateToDateStringFormatter, potentialDateToHourAndMinuteFormatter } from "@/lib/formatters/date-formatter"
import { cn } from "@/lib/utils"
import { ComponentWithClassNameAndChildren } from "@/types/utils"
import { addDays } from "date-fns"
import { Label, ReferenceLine, XAxis } from "recharts"

const now = new Date(Date.now());

const data = [
  {
    date: addDays(now, 1).getTime(),
    speeds: 2000,
    other: 2100,
  },
  {
    date: addDays(now, 2).getTime(),
    speeds: 2100,
    other: 1600,
  },
  {
    date: addDays(now, 3).getTime(),
    speeds: 2200,
    other: 1300,
  },
  {
    date: addDays(now, 4).getTime(),
    speeds: 1300,
    other: 2000,
  },
  {
    date: addDays(now, 5).getTime(),
    speeds: 1400,
    other: 1400,
  },
  {
    date: addDays(now, 6).getTime(),
    speeds: 2500,
    other: 2200,
  },
  {
    date: addDays(now, 7).getTime(),
    speeds: 1600,
    other: 2500,
  },
]

export function ChartsExample() {
  return (
    <Card>
      <CardHeader>
        <CardTitle>
          Events captured over time
        </CardTitle>
        <CardDescription>Showing mac address events grouped by time and calculated speeds.</CardDescription>
      </CardHeader>

      <CardContent>
        <div className="grid gap-8">

          <INTERNAL__ContentWrapper>
            <ChartDisplay
              __tag="__bar_chart"
              index="date"
              config={{
                speeds: {
                  label: "Average speed",
                  color: "hsl(var(--chart-1))",
                },
                other: {
                  label: "Other data",
                  color: "hsl(var(--chart-2))",
                },
              }}
              data={data}
              overrides={{
                axisDx: <XAxis
                  dataKey={'date'}
                  tickLine={false}
                  axisLine={false}
                  tickMargin={8}
                  tickFormatter={potentialDateToHourAndMinuteFormatter}
                />,
                tooltip: <ChartTooltip
                  defaultIndex={2}
                  content={
                    <ChartTooltipContent
                      hideIndicator
                      labelFormatter={(_, p) => {
                        const date = p[0].payload?.date
                        return potentialDateToDateStringFormatter(date)
                      }}
                    />
                  }
                />
              }}
            >
              <ReferenceLine
                y={1200}
                stroke="hsl(var(--muted-foreground))"
                strokeDasharray="3 3"
                strokeWidth={1}
              >
                <Label
                  position="insideBottomLeft"
                  value="Average Steps"
                  offset={10}
                  fill="hsl(var(--foreground))"
                />
                <Label
                  position="insideTopLeft"
                  value="12,343"
                  className="text-lg"
                  fill="hsl(var(--foreground))"
                  offset={10}
                  startOffset={100}
                />
              </ReferenceLine>
            </ChartDisplay>
          </INTERNAL__ContentWrapper>

          <INTERNAL__ContentWrapper>
            <ChartDisplay
              __tag="__area_chart"
              index="date"
              config={{
                speeds: {
                  label: "Average speed",
                  color: "hsl(var(--chart-4))",
                },
                other: {
                  label: "Other data",
                  color: "hsl(var(--chart-5))",
                },
              }}
              data={data}
              overrides={{
                axisDx: <XAxis
                  dataKey={'date'}
                  tickLine={false}
                  axisLine={false}
                  tickFormatter={potentialDateToHourAndMinuteFormatter}
                />,
              }}
            />
          </INTERNAL__ContentWrapper>

        </div>
      </CardContent>
    </Card>
  )
}

export function INTERNAL__ContentWrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={"overflow-x-auto"}>
      <div className={cn("min-w-[12rem]", className)}>
        {children}
      </div>
    </div>
  )
}
